<?php
if(!defined('ABSPATH')) exit;

// 現在の投稿IDを取得
$current_post_id = get_the_ID();

// 現在の投稿のカテゴリとタグを取得
$categories = wp_get_post_categories($current_post_id);
$tags = wp_get_post_tags($current_post_id, array('fields' => 'ids'));

// クエリの引数を設定
$args = array(
    'post_type' => 'post', // 投稿タイプ
    'posts_per_page' => 6, // 表示する投稿数
    'post__not_in' => array($current_post_id), // 現在の投稿を除外
    'orderby' => 'rand', // ランダムに表示
    'tax_query' => array(
        'relation' => 'OR',
        array(
            'taxonomy' => 'category',
            'field'    => 'term_id',
            'terms'    => $categories,
        ),
        array(
            'taxonomy' => 'post_tag',
            'field'    => 'term_id',
            'terms'    => $tags,
        ),
    ),
);

// カスタムクエリを実行
$related_query = new WP_Query($args);

if ($related_query->have_posts()) : ?>
<div class="related-posts">
    <div class="related-post-title">関連記事</div>
    <ul class="related-post-list">
        <?php while($related_query->have_posts()) : $related_query->the_post(); ?>
        <li class="related-post-item">
            <div class="related-post-thumbnail">
                <?php include get_template_directory() . '/template/common-parts/thumbnail-link.php'; ?>
            </div>
            <div class="related-post-item-title">
                <a href="<?php the_permalink(); ?>">
                    <?php the_title(); ?>
                </a>
            </div>
        </li>
        <?php endwhile; ?>
    </ul>
</div>
<?php
endif; // 関連記事がない場合はセクション全体を表示しない

// クエリのリセット
wp_reset_postdata();
?>