<?php
if (!defined('ABSPATH')) exit;
?>

<div class="articles-list">
    <?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
    <div class="article-list-item">
        <div class="article-list-thumbnail">
            <?php include get_template_directory() . '/template/common-parts/thumbnail-link.php'; ?>
        </div>
        <!-- タイトル -->
        <h2 class="article-list-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

        <div class="article-list-meta-container">
            <!-- カテゴリ -->
            <?php if (get_post_type() === 'post') : // 通常の投稿タイプだけカテゴリを表示 ?>
            <div class="article-list-category">
                <?php include get_template_directory() . '/template/common-parts/category.php'; ?>
            </div>
            <?php endif; ?>

            <!-- 更新日 -->
            <div class="article-list-date">
                <?php include get_template_directory() . '/template/common-parts/date.php'; ?>
            </div>
        </div>

        <!-- 著者情報 -->
        <div class="article-author-container">
            <div class="author-avatar">
                <?php include get_template_directory() . '/template/common-parts/author-avater.php'; ?>
            </div>
            <div class="author-name">
                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                    <?php echo esc_html(get_the_author()); ?>
                </a>
            </div>
        </div>
    </div>
    <?php endwhile; ?>
    <?php else : ?>
    <?php endif; ?>
</div>

<!-- ページネーション -->
<div class="pagination">
    <?php the_posts_pagination(array(
                'mid_size'  => 1,
                'end_size'     => 1,
                'prev_text' => __('<', 'textdomain'),
                'next_text' => __('>', 'textdomain'),
            )); ?>
</div>