<?php
if(!defined('ABSPATH')) exit;
while(have_posts()) : the_post();
get_header();
?>

<article class="single-post">
    <section class="single-post-header">

        <div class="single-post-thumbnail">
            <?php include get_template_directory() . '/template/common-parts/thumbnail-nolink.php'; ?>
        </div>

        <div class="single-post-meta-container">
            <!-- カテゴリ -->
            <div class="single-post-category">
                <div>
                    <?php include get_template_directory() . '/template/common-parts/category.php'; ?>
                </div>
            </div>

            <!-- 日付 -->
            <div class="single-post-date">
                <?php include get_template_directory() . '/template/common-parts/date.php'; ?>
            </div>
        </div>


        <!-- 記事タイトル -->
        <h1><?php the_title(); ?></h1>

        <!-- 著者情報（アバターと名前） -->
        <div class="single-post-author">
            <div class="single-post-author-avatar">
                <?php include get_template_directory() . '/template/common-parts/author-avater.php'; ?>
            </div>
            <div class="single-post-author-name">
                <div>
                    <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                        <?php echo esc_html(get_the_author()); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="single-post-content">
        <!-- 記事コンテンツ -->
        <?php the_content(); ?>
        <!-- 投稿記事下ウィジェットを表示 -->
        <?php if ( is_active_sidebar( 'after_post_widget_area' ) ) : ?>
        <div class="after-post-widget-area">
            <?php dynamic_sidebar( 'after_post_widget_area' ); ?>
        </div>
        <?php endif; ?>
    </section>

    <section class="single-post-sns-list-share">
        <?php include get_template_directory() . '/template/common-parts/sns-list-share.php'; ?>
    </section>

    <section class="single-post-author-info-box">
        <!-- 著者情報ボックス -->
        <?php include_once get_template_directory() . '/template/single-parts/author-info-box.php'; ?>
    </section>

    <!-- タグ -->
    <?php
        $tags = get_the_tags();
        if ($tags) : ?>
    <div class="single-post-tags">
        <div class="single-post-tag-item">
            <?php
                    foreach ($tags as $tag) {
                        echo '<a href="' . esc_url(get_tag_link($tag->term_id)) . '">#' . esc_html($tag->name) . '</a> ';
                    }
                    ?>
        </div>
    </div>
    <?php endif; ?>

    <section class="single-post-related-posts">
        <!-- 関連記事 -->
        <?php include_once get_template_directory() . '/template/single-parts/related-posts.php'; ?>
    </section>
</article>

<section class="single-post-breadcrumbs">
    <!-- パンくずリストはfunctions/breadcrumbs.phpで管理 -->
    <?php breadcrumbs(); ?>
</section>

<?php 
endwhile;
get_footer();
?>