<?php
if ( ! defined( 'ABSPATH' ) ) exit;
get_header();
?>

<article>
    <section class="search-header-container">
        <h1 class="search-title">
            <?php printf( esc_html__( '「%s」'), get_search_query() ); ?>
        </h1>
        <div class="search-description">
            <?php
            // 検索結果があるか確認
            if ( have_posts() ) :
                printf( esc_html__( '%s 件見つかりました。'), $wp_query->found_posts );
            else :
                esc_html_e( '0件でした。他のキーワードで検索してください。');
            endif;
            ?>
        </div>
    </section>
    <section>
        <?php if ( have_posts() ) : ?>
        <?php include_once get_template_directory() . '/template/article-list.php'; ?>
        <?php else : ?>
        <div class="no-results">
            <?php get_search_form(); ?>
        </div>
        <?php endif; ?>
    </section>
</article>

<?php
get_footer();
?>