<?php
if (!defined('ABSPATH')) exit;
// meta読み込み
require_once get_template_directory() . '/include/meta.php';
?>

<header>
    <div class="header-container">
        <?php if (is_front_page()) : ?>
        <h1 class="header-logo">
            <a href="<?php echo esc_url(home_url('/')); ?>">
                <?php
                if (has_custom_logo()) {
                    // カスタムロゴを表示
                    $custom_logo_id = get_theme_mod('custom_logo');
                    $logo = wp_get_attachment_image_src($custom_logo_id, 'full');

                    if ($logo) {
                        echo '<img src="' . esc_url($logo[0]) . '" alt="' . esc_attr(get_bloginfo('name')) . '">';
                    }
                } else {
                    // ロゴが設定されていない場合、サイトのタイトルをテキストで表示
                    echo esc_html(get_bloginfo('name'));
                }
                ?>
            </a>
        </h1>
        <?php else : ?>
        <div class="header-logo">
            <a href="<?php echo esc_url(home_url('/')); ?>">
                <?php
                if (has_custom_logo()) {
                    // カスタムロゴを表示
                    $custom_logo_id = get_theme_mod('custom_logo');
                    $logo = wp_get_attachment_image_src($custom_logo_id, 'full');

                    if ($logo) {
                        echo '<img src="' . esc_url($logo[0]) . '" alt="' . esc_attr(get_bloginfo('name')) . '">';
                    }
                } else {
                    // ロゴが設定されていない場合、サイトのタイトルをテキストで表示
                    echo esc_html(get_bloginfo('name'));
                }
                ?>
            </a>
        </div>
        <?php endif; ?>
        <div class="header-nav-btn" id="header-nav-btn">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <div class="header-nav-menu" id="header-nav-menu">
        <div class="header-nav-menu-title">
            <div>
                MENU
            </div>
        </div>
        <div class="header-nav-menu-container">
            <!-- メニュー内ウィジェットを表示 -->
            <?php if ( is_active_sidebar( 'open_menu_widget_area' ) ) : ?>
            <div class="header-widget-area">
                <?php dynamic_sidebar( 'open_menu_widget_area' ); ?>
            </div>
            <?php else: ?>
            <!-- open_menu_widget_area に何も設定されていない場合のみメニューを表示 -->
            <?php
            wp_nav_menu(array(
                'theme_location' => 'primary',
                'container' => false,
                'menu_class' => 'header-nav-menu',
            ));
            ?>
            <?php endif; ?>
        </div>
    </div>
</header>

<main class="pc-width">