<?php
if(!defined('ABSPATH')) exit;

function register_widget_areas() {
    register_sidebar( array(
		'name' => '投稿記事下',
		'id' => 'after_post_widget_area',
		'description' => '投稿記事コンテンツすぐ下の表示エリア。',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget_title">',
		'after_title' => '</div>',
	));
	
	register_sidebar( array(
		'name' => 'ナビゲーションメニュー内',
		'id' => 'open_menu_widget_area',
		'description' => 'ナビゲーションメニュー内の表示エリア。',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget_title">',
		'after_title' => '</div>',
	));
	
	register_sidebar( array(
		'name' => 'フッター内',
		'id' => 'inner_fotter_widget_area',
		'description' => 'フッター内の表示エリア。',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget_title">',
		'after_title' => '</div>',
	));
	
	register_sidebar( array(
		'name' => '目次下（投稿ページのみ）',
		'id' => 'after_toc_widget_area',
		'description' => '投稿ページ目次下の表示エリア。',
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget' => '</section>',
		'before_title' => '<div class="widget_title">',
		'after_title' => '</div>',
	));
}

add_action( 'widgets_init', 'register_widget_areas' );

//目次下ウィジェットの挿入

function add_after_toc_widget_area($content) {
    if (is_single() && is_active_sidebar('after_toc_widget_area')) {
        ob_start();
        dynamic_sidebar('after_toc_widget_area');
        $widget_area_content = ob_get_clean();

        // ウィジェットエリアの内容をdivで囲む
        $widget_area = '<div class="after_toc_widget_area">' . $widget_area_content . '</div>';

        // 最初のh2タグを見つける
        $first_h2_pos = strpos($content, '<h2');
        if ($first_h2_pos !== false) {
            // 最初のh2タグの前にウィジェットエリアを挿入
            $content = substr_replace($content, $widget_area, $first_h2_pos, 0);
        }
    }
    return $content;
}

// 目次生成の後で実行するように優先度を低く設定
add_filter('the_content', 'add_after_toc_widget_area', 12);