<?php
if (!defined('ABSPATH')) exit; 

function enqueue_assets() {
    // WordPress標準のjQueryをそのまま読み込む場合は以下を使用
    // wp_enqueue_script('jquery');

    // WordPress標準のjQueryをデキューし、フッターで読み込む
    wp_deregister_script('jquery');
    wp_register_script('jquery', includes_url('/js/jquery/jquery.min.js'), false, null, true);
    wp_enqueue_script('jquery');


    // common.jsの絶対パスを取得
    $common_js_path = get_template_directory() . '/assets/js/common.js';
    // common.jsの最終更新時間をバージョンとして使用
    $common_js_version = file_exists($common_js_path) ? filemtime($common_js_path) : null;
    // 全ページ共通のJavaScriptを読み込み
    wp_enqueue_script('common-js', get_template_directory_uri() . '/assets/js/common.js', array('jquery'), $common_js_version, true);

    if (is_front_page()) {
        // フロントページでのみ読み込みたいJavaScript
    }
}

// アクションフックに関数を追加し、優先度を100に設定して後で実行されるようにする。
add_action('wp_enqueue_scripts', 'enqueue_assets', 100);