<?php
if (!defined('ABSPATH')) exit;

function enqueue_combined_styles() {
    // 基本CSSファイルのパスとバージョンを配列で定義
    $css_files = [
        'reset' => get_template_directory() . '/assets/css/reset.css',
        'variables' => get_template_directory() . '/assets/css/variables.css',
        'base' => get_template_directory() . '/assets/css/_base.css',
        'block' => get_template_directory() . '/assets/css/block.css',
    ];

    // ページごとのCSSを配列で定義
    $page_css_files = [
        'front-page' => get_template_directory() . '/assets/css/front-page.css',
        'single' => get_template_directory() . '/assets/css/single.css',
        'page' => get_template_directory() . '/assets/css/page.css',
        'archive' => get_template_directory() . '/assets/css/archive.css',
        'search' => get_template_directory() . '/assets/css/search.css',
        '404' => get_template_directory() . '/assets/css/error.css',
    ];

    // ページごとの識別子を取得し、対応するCSSファイルを追加
    $page_type = 'common';
    
     // ページタイプごとに条件を明示的にチェック
     if (is_front_page() && file_exists($page_css_files['front-page'])) {
        $css_files['front-page'] = $page_css_files['front-page'];
        $page_type = 'front-page';
    } elseif (is_single() && file_exists($page_css_files['single'])) {
        $css_files['single'] = $page_css_files['single'];
        $page_type = 'single';
    } elseif (is_page() && file_exists($page_css_files['page'])) {
        $css_files['page'] = $page_css_files['page'];
        $page_type = 'page';
    } elseif (is_archive() && file_exists($page_css_files['archive'])) {
        $css_files['archive'] = $page_css_files['archive'];
        $page_type = 'archive';
    } elseif (is_search() && file_exists($page_css_files['search'])) {
        $css_files['search'] = $page_css_files['search'];
        $page_type = 'search';
    } elseif (is_404() && file_exists($page_css_files['404'])) {
        $css_files['404'] = $page_css_files['404'];
        $page_type = '404';
    }

    // バージョン管理用のタイムスタンプを作成
    $version = '';
    foreach ($css_files as $file) {
        if (file_exists($file)) {
            $version .= filemtime($file);
        }
    }

    // 結合されたCSSファイルのパスと名前を決定
    $combined_css_filename = 'combined-' . $page_type . '-' . md5($version) . '.css';
    $combined_css_directory = get_template_directory() . '/assets/css/combined/';
    $combined_css_path = $combined_css_directory . $combined_css_filename;

    // 結合CSSディレクトリが存在しない場合は作成
    if (!is_dir($combined_css_directory)) {
        mkdir($combined_css_directory, 0755, true);
    }

    // 古い結合ファイルを削除
    $files = glob($combined_css_directory . 'combined-' . $page_type . '-*.css');
    foreach ($files as $file) {
        if (basename($file) !== $combined_css_filename) {
            @unlink($file);  // 最新でないファイルを削除
        }
    }

    // 結合ファイルが存在しない場合のみCSSファイルを結合
    if (!file_exists($combined_css_path)) {
        $combined_css = '';
        foreach ($css_files as $file) {
            if (file_exists($file)) {
                $combined_css .= file_get_contents($file);
            }
        }

        // コメントを削除し、圧縮
        $combined_css = preg_replace('!/\*.*?\*/!s', '', $combined_css);
        $combined_css = preg_replace('/\s+/', ' ', $combined_css);

        // 結合されたCSSファイルを保存
        file_put_contents($combined_css_path, $combined_css);
    }

    // 結合されたCSSを読み込む
    wp_enqueue_style('combined-css', get_template_directory_uri() . '/assets/css/combined/' . basename($combined_css_path), [], filemtime($combined_css_path));
}
add_action('wp_enqueue_scripts', 'enqueue_combined_styles');

// FontAwesomeはフッターで読み込む
function enqueue_fontawesome_in_footer() {
    // FontAwesomeのCSS
    $fontawesome_css_path = get_template_directory() . '/assets/fonts/fontawesome/all.min.css';
    wp_enqueue_style('fontawesome-css', get_template_directory_uri() . '/assets/fonts/fontawesome/all.min.css', [], filemtime($fontawesome_css_path), 'all', true);
}
add_action('wp_footer', 'enqueue_fontawesome_in_footer');

// ブロックエディタ用スタイルを読み込み
function enqueue_block_editor_styles() {
    wp_enqueue_style(
        'block-editor-styles',
        get_template_directory_uri() . '/assets/css/editor.css',
        [],
        wp_get_theme()->get('Version')
    );
}
add_action('enqueue_block_editor_assets', 'enqueue_block_editor_styles');