<?php
if (!defined('ABSPATH')) exit;

/*
 * wp_headから余計な記述を削除
*/
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'wp_shortlink_wp_head');
remove_action('wp_head', 'wp_oembed_add_discovery_links');
remove_action('wp_head', 'rest_output_link_wp_head');
remove_action('wp_head', 'print_emoji_detection_script', 7);
remove_action('wp_print_styles', 'print_emoji_styles');
remove_action('wp_head', 'wp_resource_hints', 2);
remove_action( 'embed_head', 'print_embed_styles' );
remove_action( 'embed_footer', 'print_embed_sharing_dialog' );
//管理バーを非表示にしたい場合はコメントアウトを外す
// add_filter('show_admin_bar', '__return_false');

// titleタグのサポートを追加
add_theme_support('title-tag');

/*
 * アーカイブページタイトルから不要な文字列を削除
*/
function remove_prefix_from_archive_title($title) {
    $prefixes = ['アーカイブ: ', 'カテゴリー: ', 'タグ: ', '投稿者: ', '日: ','月: ', '年: '];
    foreach ($prefixes as $prefix) {
        if (strpos($title, $prefix) === 0) {
            $title = substr($title, strlen($prefix));
            break;
        }
    }
    return $title;
}
add_filter('get_the_archive_title', 'remove_prefix_from_archive_title');

// ユーザープロフィールに設置する画像アップタグを出力する
function generate_upload_image_tag($name, $value) { ?>
<input name="<?php echo $name; ?>" type="text" value="<?php echo $value; ?>" />
<input type="button" name="<?php echo $name; ?>_select" value="選択" />
<input type="button" name="<?php echo $name; ?>_clear" value="クリア" />
<div id="<?php echo $name; ?>_thumbnail" class="uploaded-thumbnail">
    <?php if ($value): ?>
    <img src="<?php echo $value; ?>" alt="選択中の画像">
    <?php endif ?>
</div>

<script type="text/javascript">
(function($) {
    var custom_uploader;
    $("input:button[name=<?php echo $name; ?>_select]").click(function(e) {
        e.preventDefault();
        if (custom_uploader) {
            custom_uploader.open();
            return;
        }
        custom_uploader = wp.media({
            title: "画像を選択してください",
            library: {
                type: "image"
            },
            button: {
                text: "画像の選択"
            },
            multiple: false
        });
        custom_uploader.on("select", function() {
            var images = custom_uploader.state().get("selection");
            images.each(function(file) {
                $("input:text[name=<?php echo $name; ?>]").val("");
                $("#<?php echo $name; ?>_thumbnail").empty();
                $("input:text[name=<?php echo $name; ?>]").val(file.attributes.sizes.full
                    .url);
                $("#<?php echo $name; ?>_thumbnail").append('<img src="' + file.attributes
                    .sizes.full.url + '" />');
            });
        });
        custom_uploader.open();
    });
    $("input:button[name=<?php echo $name; ?>_clear]").click(function() {
        $("input:text[name=<?php echo $name; ?>]").val("");
        $("#<?php echo $name; ?>_thumbnail").empty();
    });
})(jQuery);
</script>
<?php
}

// プロフィールにカスタム画像フィールドを追加
function custom_user_profile_fields($user) {
    ?>
<h3>プロフィール写真</h3>
<div>
    <?php
        $user_profile_image = get_user_meta($user->ID, 'user_profile_image', true);
        generate_upload_image_tag('user_profile_image', $user_profile_image);
        ?>
</div>
<?php
}
add_action('show_user_profile', 'custom_user_profile_fields');
add_action('edit_user_profile', 'custom_user_profile_fields');

// 画像を保存する処理
function save_custom_user_profile_fields($user_id) {
    if (!current_user_can('edit_user', $user_id)) {
        return false;
    }
    if (isset($_POST['user_profile_image'])) {
        update_user_meta($user_id, 'user_profile_image', esc_url_raw($_POST['user_profile_image']));
    }
}
add_action('personal_options_update', 'save_custom_user_profile_fields');
add_action('edit_user_profile_update', 'save_custom_user_profile_fields');

// メディアアップローダの JavaScript API を読み込む
function my_admin_scripts() {
    wp_enqueue_media();
}
add_action('admin_enqueue_scripts', 'my_admin_scripts');

//ウィジェット設定をクラシックに戻す
add_filter('use_widgets_block_editor', '__return_false');