<?php
if(!defined('ABSPATH')) exit;

function breadcrumbs() {
    global $post;
    $delimiter = '>'; // 区切り文字
    $home = 'Top'; // トップページの名前
    $before = '<span class="current">'; // 現在のページのマークアップ
    $after = '</span>'; // 現在のページのマークアップの終了

    if (!is_home() && !is_front_page() || is_paged()) {

        echo '<div class="breadcrumbs-container"><div id="breadcrumbs" class="breadcrumbs"><a href="' . home_url() . '">' . $home . '</a> ' . $delimiter . ' ';

        if (is_category()) {
            $thisCat = get_category(get_query_var('cat'), false);
            if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ' . $delimiter . ' ');
            echo $before . 'category "' . single_cat_title('', false) . '"' . $after;

        } elseif (is_page() && !$post->post_parent) {
            echo $before . get_the_title() . $after;

        } elseif (is_page() && $post->post_parent) {
            $parent_id = $post->post_parent;
            $breadcrumbs = array();
            while ($parent_id) {
                $page = get_post($parent_id);
                $breadcrumbs[] = '<a  href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
                $parent_id = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                echo $breadcrumbs[$i];
                if ($i != count($breadcrumbs)-1) echo ' ' . $delimiter . ' ';
            }
            echo ' ' . $delimiter . ' ' . $before . get_the_title() . $after;

        } elseif (is_single() && !is_attachment()) {
            if (get_post_type() != 'post') {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                echo '<a  href="' . home_url('/') . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
                echo ' ' . $delimiter . ' ' . $before . get_the_title() . $after;
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                echo $before . get_the_title() . $after;
            }

        } elseif (is_tag()) {
            echo $before . 'tag"' . single_tag_title('', false) . '"' . $after;

        } elseif (is_author()) {
            global $author;
            $userdata = get_userdata($author);
            echo $before . 'author' . $userdata->display_name . $after;

        } elseif (is_404()) {
            echo $before . '404' . $after;
        }

        if (get_query_var('paged')) {
            if (is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author()) echo ' (';
            echo __('Page') . ' ' . get_query_var('paged');
            if (is_category() || is_day() or is_month() or is_year() or is_search() or is_tag() or is_author()) echo ')';
        }

        echo '</div></div>';

    }
}